﻿using Microsoft.IdentityModel.Clients.ActiveDirectory;
using Microsoft.Xrm.Sdk.WebServiceClient;
using Microsoft.Xrm.Sdk.WebServiceClient.Async;
using System;
using System.Configuration;
using System.Threading.Tasks;
using VA.PPMS.Context;

namespace PpmsDataService.VA.PPMS.Context
{
    public class PpmsContextHelper
    {
        private static string _token;
        private static DateTime _expires = DateTime.Now;

        public static async Task<PpmsContext> GetContext()
        {
            return new PpmsContext(await GetProxy());
        }
        
        public static async Task<OrganizationWebProxyAsyncClient> GetProxy()
        {
            if (string.IsNullOrEmpty(_token) || DateTime.Now.ToUniversalTime() >= _expires)
            {
                _token = await GetToken();
            }

            var baseCrmUri = ConfigurationManager.AppSettings["baseCrmUri"];
            var client = new OrganizationWebProxyClient(new Uri(string.Format("{0}/XRMServices/2011/Organization.svc/web", baseCrmUri)), typeof(Account).Assembly) { HeaderToken = _token };

            return client.ToAsyncClient();
        }
        
        public static async Task<string> GetToken()
        {
            var baseCrmUri = ConfigurationManager.AppSettings["baseCrmUri"];
            var ap = await AuthenticationParameters.CreateFromResourceUrlAsync(new Uri(string.Format("{0}/api/data/", baseCrmUri)));
            var authorityUrl = ap.Authority;
            var resourceUrl = ap.Resource;
            var authContext = new AuthenticationContext(authorityUrl, true, TokenCache.DefaultShared);

            var clientId = ConfigurationManager.AppSettings["clientId"];
            var clientSecret = ConfigurationManager.AppSettings["clientSecret"];
            var clientCredential = new ClientCredential(clientId, clientSecret);

            var token = await authContext.AcquireTokenAsync(resourceUrl, clientCredential);
            _expires = token.ExpiresOn.DateTime;
            var result = token.AccessToken;

            return result;
        }
    }
}